<?php
	// MyBB Restrict IP plugin code.
	// (C) 2010 CubicleSoft.  All Rights Reserved.
	//
	// This plugin is free to use with the MyBB forum software package.
	// Restricts moderator and/or administrator account access to specific IP addresses.
	// Creative Commons License:  http://creativecommons.org/licenses/by-nc-nd/3.0/us
	// Developed by Thomas Hruska, CubicleSoft Core.

	// Disallow direct access to this file for security reasons.
	if (!defined("IN_MYBB"))
	{
		die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
	}

	// Admin hooks.
	$plugins->add_hook("admin_config_settings_change", "RestrictIP_admin_config_settings");
	$plugins->add_hook("admin_config_settings_start", "RestrictIP_admin_config_settings");

	// Global hooks.
	$plugins->add_hook("global_end", "RestrictIP_global_end");
	$plugins->add_hook("xmlhttp", "RestrictIP_xmlhttp");

	function RestrictIP_info()
	{
		global $lang;

		$lang->load("RestrictIP_plugin_admin");

		return Array(
			"name" => $lang->RestrictIP_plugin_Name,
			"description" => $lang->RestrictIP_plugin_Desc,
			"website" => "http://mods.mybboard.net/view/restrict-ip",
			"author" => $lang->RestrictIP_plugin_Author,
			"authorsite" => "http://www.cubiclesoft.com/",
			"version" => "1.2",
			"guid" => "7d958a33f66d22d0462a7e0eb3c09cd2",
			"compatibility" => "14*,16*"
		);
	}

	function RestrictIP_install()
	{
		global $mybb, $db;

		// Delete existing settings (if any).
		$query = $db->simple_select("settinggroups", "gid", "name = 'RestrictIP_plugin'");
		$gid = $db->fetch_field($query, "gid");
		if ($gid)  $db->delete_query("settings", "gid = '" . (int)$gid . "'");
		$db->delete_query("settinggroups", "name = 'RestrictIP_plugin'");

		// Create new settings group.
		$query = $db->simple_select("settinggroups", "MAX(disporder) as rows");
		$numrows = $db->fetch_field($query, "rows");
		$insertarray = Array(
			"name" => "RestrictIP_plugin",
			"title" => "هاك الدخول بالايبي الادارة / المشرفين",
			"description" => "اعدادات الهاك",
			"disporder" => $numrows + 1,
			"isdefault" => 0
		);
		$db->insert_query("settinggroups", $insertarray);
		$gid = $db->insert_id();

		// Create 'ModIP' setting.
		$insertarray = Array(
			"name" => "RestrictIP_ModIP",
			"title" => "ايبي لوحة المشرفين",
			"description" => "ادخل عناوين الايبي التي تريد السماح لها بالدخول للوحة المشرفين . وكل ايبي في سطر واتركها فارغه للسماح للجميع ",
			"optionscode" => "textarea",
			"value" => "",
			"disporder" => 1,
			"gid" => (int)$gid
		);
		$db->insert_query("settings", $insertarray);

		// Create 'AdminIP' setting.
		$insertarray = Array(
			"name" => "RestrictIP_AdminIP",
			"title" => "ايبي لوحة الادارة",
			"description" => "ادخل عناوين الايبي التي تريد السماح لها بالدخول للوحة الادارة . وكل ايبي في سطر واتركها فارغه للسماح للجميع",
			"optionscode" => "textarea",
			"value" => "",
			"disporder" => 2,
			"gid" => (int)$gid
		);
		$db->insert_query("settings", $insertarray);

		rebuild_settings();
	}

	function RestrictIP_is_installed()
	{
		global $db;

		$query = $db->simple_select("settings", "sid", "name = 'RestrictIP_AdminIP'");
		$sid = $db->fetch_field($query, "sid");
		if ($sid)  return true;

		return false;
	}

	function RestrictIP_uninstall()
	{
		global $db;

		// Delete existing settings (if any).
		$query = $db->simple_select("settinggroups", "gid", "name = 'RestrictIP_plugin'");
		$gid = $db->fetch_field($query, "gid");
		if ($gid)  $db->delete_query("settings", "gid = '" . (int)$gid . "'");
		$db->delete_query("settinggroups", "name = 'RestrictIP_plugin'");

		rebuild_settings();
	}

	function RestrictIP_admin_config_settings()
	{
		global $lang;

		$lang->load("RestrictIP_plugin_admin");
	}

	function RestrictIP_IsValidIP($IPAddrs)
	{
		if (trim($IPAddrs) == "")  return true;

		$CurrIP = get_ip();
		$IPFilters = str_replace("\r\n", "\n", $IPAddrs);
		$IPFilters = str_replace("\r", "\n", $IPFilters);
		$IPFilters = explode("\n", $IPFilters);
		foreach ($IPFilters as $IPFilter)
		{
			$IPFilter = preg_replace('/[^0-9\.\*]/', "", $IPFilter);
			$IPFilter = str_replace('\*', "(.*)", preg_quote($IPFilter, "/"));
			if ($IPFilter != "" && preg_match("/^" . $IPFilter . "$/", $CurrIP))  return true;
		}

		return false;
	}

	// In lieu of not having 'admin_global_start'.
	if (defined("IN_ADMINCP") && !defined("MYBB_ADMIN_DIR"))
	{
		// require_once inside a function acts like a local function.
		global $mybb;

		if (!RestrictIP_IsValidIP((string)$mybb->settings["RestrictIP_AdminIP"]))  unset($mybb->cookies["adminsid"]);
	}

	function RestrictIP_global_end()
	{
		global $mybb, $lang, $current_page;

		if (is_moderator() && !($current_page == "member.php" && $mybb->input["action"] == "logout") && !RestrictIP_IsValidIP((string)$mybb->settings["RestrictIP_ModIP"]))
		{
			$lang->load("RestrictIP_plugin");

			error($lang->RestrictIP_Error);
			exit();
		}
	}

	function RestrictIP_xmlhttp()
	{
		global $mybb;

		if (is_moderator() && !RestrictIP_IsValidIP((string)$mybb->settings["RestrictIP_ModIP"]))  exit();
	}
?>